/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.util.concurrent.Executors;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;

public abstract class AsyncZipTask<T> {
    private ProgressMonitor progressMonitor;
    private boolean runInThread;

    public AsyncZipTask(ProgressMonitor progressMonitor, boolean runInThread) {
        this.progressMonitor = progressMonitor;
        this.runInThread = runInThread;
    }

    public void execute(T taskParameters) throws ZipException {
        this.progressMonitor.fullReset();
        this.progressMonitor.setState(ProgressMonitor.State.BUSY);
        this.progressMonitor.setCurrentTask(this.getTask());
        if (this.runInThread) {
            long totalWorkToBeDone = this.calculateTotalWork(taskParameters);
            this.progressMonitor.setTotalWork(totalWorkToBeDone);
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    this.performTaskWithErrorHandling(taskParameters, this.progressMonitor);
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            });
        } else {
            this.performTaskWithErrorHandling(taskParameters, this.progressMonitor);
        }
    }

    private void performTaskWithErrorHandling(T taskParameters, ProgressMonitor progressMonitor) throws ZipException {
        try {
            this.executeTask(taskParameters, progressMonitor);
            progressMonitor.endProgressMonitor();
        }
        catch (ZipException e) {
            progressMonitor.endProgressMonitor(e);
            throw e;
        }
        catch (Exception e) {
            progressMonitor.endProgressMonitor(e);
            throw new ZipException(e);
        }
    }

    protected void verifyIfTaskIsCancelled() throws ZipException {
        if (!this.progressMonitor.isCancelAllTasks()) {
            return;
        }
        this.progressMonitor.setResult(ProgressMonitor.Result.CANCELLED);
        this.progressMonitor.setState(ProgressMonitor.State.READY);
        throw new ZipException("Task cancelled", ZipException.Type.TASK_CANCELLED_EXCEPTION);
    }

    protected abstract void executeTask(T var1, ProgressMonitor var2) throws IOException;

    protected abstract long calculateTotalWork(T var1) throws ZipException;

    protected abstract ProgressMonitor.Task getTask();
}

